# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Configure publishing permissions for the Pages library
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site
$webUrl = "http://sharepoint/site"

# User to add as the first member and owner of the groups
$defaultUserName = "domain\username"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Get the SharePoint Site
$web = Get-SPWeb $webUrl

# Get the Pages Library
$pages = $web.Lists["Pages"]

# If the Pages Library is inheriting permissions, break inheritance
if ($pages.HasUniqueRoleAssignments -eq $false)
{
	$pages.BreakRoleInheritance($false)
}

# Enable the Requirement for Content Approval
$pages.EnableModeration = $true
$pages.Update()
	
# Get the Default Username as SPMember and SPUser objects
$member = [Microsoft.SharePoint.SPMember] $web.Users[$defaultUserName]
$user = [Microsoft.SharePoint.SPUser] $web.Users[$defaultUserName]

# Create the Approver and Contributors groups
$web.SiteGroups.Add("Pages Approvers", $member, $user, "These users can approve submissions in the Pages Library")
$web.SiteGroups.Add("Pages Contributors", $member, $user, "These users can edit content in the Pages Library")

# Get the newly created groups
$approvers = $web.SiteGroups["Pages Approvers"]
$contributors = $web.SiteGroups["Pages Contributors"]

# Get the Approve and Contibure roles from the Site
$roleApprover = $web.RoleDefinitions["Approve"]
$roleContribute = $web.RoleDefinitions["Contribute"]

# Assign the Approve role to the Approvers group
$assignmentApprove = New-Object Microsoft.SharePoint.SPRoleAssignment($approvers)
$assignmentApprove.RoleDefinitionBindings.Add($roleApprover)
$pages.RoleAssignments.Add($assignmentApprove)

# Assign the Contribute role to the Contributors group
$assignmentContribute = New-Object Microsoft.SharePoint.SPRoleAssignment($contributors)
$assignmentContribute.RoleDefinitionBindings.Add($roleContribute)
$pages.RoleAssignments.Add($assignmentContribute)

# Update the Pages Library
$pages.Update()

# Dispose of the site object
$web.Dispose()

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 